﻿/*
VERSION:		1.1

NOTE:
	Do not use this if your pseudo-component is going to contain custom components.
	All of their mouse functionality will be disabled if you do.
	
	Default flash components such as "Button" and "List" are not affected for some reason.
	Only your custom components are adversely affected by this.
	
USAGE:
	#include "functions/addMouseEvents.as"
	addMouseEvents( this );
*/

addMouseEvents = function( _this )
{
	// _________________________________________________
	// MOUSE EVENTS
	_this.triggerChildren = function( functName )
	{
		for(var nam in _this)
		{
			if( typeof(_this[nam]) == "movieclip"  &&  _this[nam] != _this )
			{
				_this[nam][functName]();		// call trigger
			}
		}// for:  all children
	}// triggerChildren()
	
	
	
	_this.triggerHitChildren = function( functName )
	{
		for(var nam in _this)
		{
			if( typeof(_this[nam]) == "movieclip"  &&  _this[nam] != _this )
			{
				if( _this[nam].hitTest(_root._xmouse, _root._ymouse, false) ){
					var path = _this+"."+nam+"."+functName;
					_this[nam][functName]();		// call trigger
				}
			}
		}// for:  all children
	}// triggerHitChildren()
	
	
	
	_this.onDragOut = function(){
		_this.dispatchEvent({type:"onDragOut"});
		triggerChildren("onDragOut");
	}// onDragOut()
	_this.onDragOver = function(){
		_this.dispatchEvent({type:"onDragOver"});
		triggerChildren("onDragOver");
	}// onDragOver()
	_this.onMouseMove = function(){
		_this.dispatchEvent({type:"onMouseMove"});
	}// onMouseMove()
	_this.onPress = function(){
		_this.dispatchEvent({type:"onPress"});
		triggerHitChildren("onPress");
	}// onPress()
	_this.onRelease = function(){
		_this.dispatchEvent({type:"onRelease"});
		triggerHitChildren("onRelease");
	}// onRelease()
	_this.onReleaseOutside = function(){
		_this.dispatchEvent({type:"onReleaseOutside"});
		triggerChildren("onReleaseOutside");
	}// onReleaseOutside()
	_this.onRollOut = function(){
		_this.dispatchEvent({type:"onRollOut"});
		triggerChildren("onRollOut");
	}// onRollOut()
	_this.onRollOver = function(){
		_this.dispatchEvent({type:"onRollOver"});
		triggerChildren("onRollOver");
	}// onRollOver()
}// addMouseEvents()